
// ScheduleRecordingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScheduleRecording.h"
#include "ScheduleRecordingDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CScheduleRecordingDlg dialog

CScheduleRecordingDlg::CScheduleRecordingDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CScheduleRecordingDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CScheduleRecordingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_DEVICE, m_comboxCaptureDevice);
}

BEGIN_MESSAGE_MAP(CScheduleRecordingDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDOK, &CScheduleRecordingDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CScheduleRecordingDlg message handlers

BOOL CScheduleRecordingDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here		

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	CenterWindow( this );

	/*
	m_comboxCaptureDevice.ResetContent();	
	
	// To enumerate all capture devices on the platform
	//
	ULONGLONG		* p_video_device_list = NULL ;

	ULONGLONG		* p_video_encoder_device_list = NULL ;

	ULONGLONG		* p_audio_device_list = NULL ;

	ULONGLONG		* p_audio_encoder_device_list = NULL ;

	ULONG					n_video_device_list_size = 0 ;

	ULONG					n_video_encoder_device_list_size = 0 ;

	ULONG					n_audio_device_list_size = 0 ;

	ULONG					n_audio_encoder_device_list_size = 0 ;

	ULONG					nChannelNum = 0;

	BOOL						bSuccess = FALSE;

	char pszHexString[ 20 ] = {0};

	char pszASCIIChar[ 6 ] = {0};

	char pszDevName[ 20 ] = {0};

	bSuccess = AMESDK_CAPTURE_DEVICE_NAME_ENUMERATION ( &p_video_device_list,

																													  &n_video_device_list_size,

																													  &p_video_encoder_device_list,

																													  &n_video_encoder_device_list_size,

																													  &p_audio_device_list,

																													  &n_audio_device_list_size,

																													  &p_audio_encoder_device_list,

																													  &n_audio_encoder_device_list_size );

	int nHexStringLen = 0;	

	CString strDeviceName, str1, str2, str3;

	CString strCurrentDevice, strDeviceTemp;

	const char * pszDev;

	int nIndex = 0;

	char szbuf = 0;

	bool bIsSameDev = false;

	for ( ULONG i = 0 ; i < n_video_device_list_size ; i++ ) {		

		sprintf_s( pszHexString, "%llX", p_video_device_list[ i ]  );

		strDeviceName = pszHexString;

		str1= strDeviceName.Left( 4 );         // EX: DC

		str2 = strDeviceName.Mid( 4, 4 );    // EX: 1150

		str3 = strDeviceName.Mid( 10, 6 );    // EX: USB

		bIsSameDev = false;

		// FOR STRING 1
		//
		if ( str1.GetLength() == 4 )
		{
			pszDev = str1;

			for( nIndex = 0 ; nIndex < 4 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}

		// FOR STRING 2
		//
		if ( str2.GetLength() == 4 )
		{
			sprintf_s(  pszASCIIChar, "%s ", str2 );

			strcat_s( pszDevName, 20, pszASCIIChar );
		}

		// FOR STRING 3
		//
		if ( str3.GetLength() == 6 )
		{
			pszDev = str3;

			for( nIndex = 0 ; nIndex < 6 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}

		strDeviceTemp = pszDevName;

		if ( strDeviceTemp != strCurrentDevice )
		{
			 strCurrentDevice = strDeviceTemp;		

			 nChannelNum = 0;			
		}		
		else
		{
			bIsSameDev = true;
		}

		nChannelNum++;
	
		m_MapDeviceWithChNum.insert( std::make_pair<CString, ULONG>( strDeviceTemp,  nChannelNum ) );

		if ( bIsSameDev )
		{
			std::map<CString, ULONG>::iterator it;

			it = m_MapDeviceWithChNum.find( strDeviceTemp );

			it->second = nChannelNum;
		}
		
		memset( pszDevName, 0, 20 );
	}	

	std::map<CString, ULONG>::iterator iter = m_MapDeviceWithChNum.begin();

	strDeviceName = "";

	ULONG nCH = 0;

	CString strFullDeviceName;

	S_DEV_INFO  dsDevInfo;

	while ( iter != m_MapDeviceWithChNum.end() )
	{
		strDeviceName = iter->first;

		nCH = iter->second;

		strFullDeviceName.Format( "( %s , N%d ) ",  strDeviceName, nCH );

		m_comboxCaptureDevice.AddString( strFullDeviceName );

		lstrcpy( dsDevInfo.m_pszDevName, strDeviceName );

		dsDevInfo.m_nCHNum = nCH;

		m_VectorDeviceInfo.push_back( dsDevInfo );

		iter++;
	}	

	if ( m_comboxCaptureDevice.GetCount() > 0 )
	{
		m_comboxCaptureDevice.SetCurSel( 0 );
	}
	*/

	SetTimer( 0x00000001, 10, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

int CScheduleRecordingDlg::HexToInt( char c )
{
        int first = c / 16 - 3;		//    1st is dec 48 = char 0
        int second = c % 16;	//      10 in 1st16  5 in 2nd 16

        // decimal code of ascii char 0-9:48-57  A-E: 65-69
        // omit dec 58-64:  :,;,<,=,>,?,@
        // map first or second 16 range to 0-9 or 10-15
		//
        int result = ( first * 10 ) + second; 

        if(result > 9) result--;

        return result;
}

int CScheduleRecordingDlg::HexToAscii( char c, char d )
{
        int high = HexToInt( c ) * 16;

        int low = HexToInt( d );

        return high + low;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CScheduleRecordingDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CScheduleRecordingDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CScheduleRecordingDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here	
	
}

CString CScheduleRecordingDlg::GetWorkingPath( CString strWorkFile )
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}

void CScheduleRecordingDlg::OnTimer(UINT_PTR nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if ( 0x00000001 == nIDEvent )
	{
		KillTimer( 0x00000001 );

		CDialogEx::OnOK();

		BeginWaitCursor();

		ZeroMemory( &m_infoProcess, sizeof(m_infoProcess) );

		CString strExeFile;			

 #if ( X86_MACHINE == 1 )
		strExeFile.Format( "%s", GetWorkingPath( "SC540.X86.EXE" ) );
#else
		strExeFile.Format( "%s", GetWorkingPath( "SC540.X64.EXE" ) );
#endif

		ExecuteProcess( strExeFile.GetBuffer( 256 ) );

		strExeFile.ReleaseBuffer();

		Sleep( 5000 );

		EndWaitCursor();

		CString strCaption;

		strCaption.Format( " Yuan's SC540 (%s) N%d Stream Recording Demo Software", "QP0203 PCI", 8 );

		lstrcpy( m_oSetupDialog.m_pszDevName , "QP0203 PCI" );
		
		m_oSetupDialog.m_nCHNum = 8;

		m_oSetupDialog.m_strCaption = strCaption;

		m_oSetupDialog.DoModal();
	}

	CDialog::OnTimer(nIDEvent);
}

void CScheduleRecordingDlg::OnDestroy() 
{
	KillTimer( 0x00000001 );

	// Close process and thread handles
	//
	if ( m_infoProcess.hProcess != NULL )
	{
		CString str;

		str.Format( "Terminate Process %d \n", m_infoProcess.dwProcessId ); OutputDebugString( str );		

		BOOL bTerminate = FALSE;

		bTerminate = TerminateProcess( m_infoProcess.hProcess, 0 );

		if( !bTerminate )
		{
			OutputDebugString( "Fail to Terminate Process \n" );
		}

		m_infoProcess.hProcess = NULL;
	}

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CScheduleRecordingDlg::ExecuteProcess( TCHAR *pszCmdLine )
{
	STARTUPINFO si;	

	ZeroMemory( &si, sizeof(si) );	

	si.cb = sizeof(si);

	ZeroMemory( &m_infoProcess, sizeof(m_infoProcess) );

	BOOL bCreate = FALSE;

	// Start the child process
	//
	bCreate = CreateProcess( NULL,						// No module name (use command line)
							 pszCmdLine,							// Command line
							 NULL,									// Process handle not inheritable
							 NULL,									// Thread handle not inheritable
							 FALSE,									// Set handle inheritance to FALSE
							 CREATE_NO_WINDOW,		// No creation flags
							 NULL,									// Use parent's environment block
							 NULL,									// Use parent's starting directory 
							 &si,											// Pointer to STARTUPINFO structure
							 &m_infoProcess );					// Pointer to PROCESS_INFORMATION structure

	// Wait until child process exits.
	//
	// WaitForSingleObject( m_infoProcess.hProcess, INFINITE );
	
	return bCreate;
}